﻿using System;
using System.Text;

public class Device
{
    #region properties

    [System.Runtime.InteropServices.DllImport("coredll.dll")]
    private static extern bool SystemParametersInfo(uint uiAction, uint uiParam, StringBuilder pvParam, uint fWinIni);

    private const uint SpiGetplatformtype = 257;
    private const uint SpiGetoeminfo = 258;

    #endregion

    public static string Platform
    {
        get
        {
            var strPlatform = new StringBuilder(200);
            SystemParametersInfo(SpiGetplatformtype, 200, strPlatform, 0);

            return strPlatform.ToString();
        }
    }

    public static bool IsWM
    {
        get
        {
            if (Platform.IndexOf("PocketPC", StringComparison.Ordinal) != -1)
                return true;
            if (Environment.OSVersion.ToString().IndexOf("CE", StringComparison.Ordinal) != -1)
            {
                return false;
            }
            return true;
        }
    }

    public static string OEMInfo
    {
        get
        {
            var strOemInfo = new StringBuilder(200);
            SystemParametersInfo(SpiGetoeminfo, 200, strOemInfo, 0);

            return strOemInfo.ToString();
        }
    }
}
    

